#!/bin/bash

# collect meminfo and docker disk
printf "  %-20s %-15s %-15s %-15s %-15s \n" "Time" "MemTotal" "MemFree" "MemAvailable" "DockerFiles(MB)" | tee -a /var/log/collector.log

while true
do
    curTime=$(printf "%(%Y-%m-%dT%H:%M:%S)T" -1)
    memTotal=$(cat /proc/meminfo|grep MemTotal|awk '{print $2 $3}')
    memFree=$(cat /proc/meminfo|grep MemFree|awk '{print $2 $3}')
    memAva=$(cat /proc/meminfo|grep MemAvailable|awk '{print $2 $3}')
    dockerFiles=$(du -ms /var/lib/docker|awk '{print $1}')

    printf "  %-20s %-15s %-15s %-15s %-15s \n" $curTime $memTotal $memFree $memAva $dockerFiles | tee -a /var/log/collector.log

    sleep 10

done