#!/bin/bash


POSTGRES_USER=scalebox
POSTGRES_HOST=localhost
POSTGRES_DB=scalebox
PGPORT=5432

job_id=$1

# obsid="test.txt"
obsid="/nfsdata/share/simulation-collection/msc/v092/raw/msg-all.txt"
while IFS= read -r line
do
  m="$line"
  arr=($(echo $m | tr " " " "))
  obsid="${arr[0]}"
  detector="${arr[1]}"
  msg=$obsid-$detector
  echo $msg
  docker exec -t database psql -U ${POSTGRES_USER} -h ${POSTGRES_HOST} -d ${POSTGRES_DB} -p ${PGPORT}\
        -c "INSERT INTO t_task(job,key_message) VALUES(${job_id},'${msg}')"
done < $obsid
~
